﻿Imports System.Threading
Imports System.Runtime.InteropServices

Public Class Form1

    Private Sub cmdConnect_Click(sender As Object, e As EventArgs) Handles cmdConnect.Click

        Try
            tcpClient.Client.Connect(txtIPAddress.Text, txtPort.Text)
        Catch
            MsgBox("Could not connect..." & Err.Description)
        End Try

    End Sub

    Private Sub cmdClose_Click(sender As Object, e As EventArgs) Handles cmdClose.Click
        If tcpClient.Client.Connected Then
            tcpClient.Client.Disconnect(False)
            tcpClient = New Net.Sockets.TcpClient
        End If

    End Sub


    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick

        If tcpClient.Client.Connected Then
            ledStatus.FillColor = Color.LimeGreen
        Else
            ledStatus.FillColor = Color.Red
        End If

    End Sub


    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        'System.Windows.Forms.Control.CheckForIllegalCrossThreadCalls = False
        'TCPTask = New Thread(AddressOf TCPDataListen)
        'TCPTask.IsBackground = True
        'TCPTask.Start()



    End Sub

    'Private Sub btnSend_Click(sender As Object, e As EventArgs)

    '  If tcpClient.Connected Then
    '       tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes(txtCommand.Text & vbCrLf))
    '   End If

    ' End Sub

    Private Sub Timer2_Tick(sender As Object, e As EventArgs) Handles Timer2.Tick
        Dim bytesread As Integer
        Dim IECMonitor As MonitorStruct
        Dim bytes() As Byte


        If tcpClient.Client.Connected Then
            If tcpClient.Client.Available Then
                bytesread = tcpClient.Client.Receive(InputBuffer)

                If (bytesread > 0) Then


                    ' example used to develop code comes from here: http://www.codeproject.com/Articles/8641/Equivalent-of-CopyMemory-in-NET
                    ' GCHandle documentation: http://msdn.microsoft.com/en-us/library/system.runtime.interopservices.gchandle.aspx
                    ' Marshal documentation: http://msdn.microsoft.com/en-us/library/system.runtime.interopservices.marshal.aspx
                    ' Byte reversal from http://msdn.microsoft.com/en-us/library/system.bitconverter(v=vs.110).aspx?cs-save-lang=1&cs-lang=vb#code-snippet-2

                    ' the next two lines are used to get a pointer to the head of the input buffer 
                    Dim Handle As GCHandle = GCHandle.Alloc(InputBuffer, GCHandleType.Pinned)
                    Dim BuffPtr As IntPtr = Handle.AddrOfPinnedObject()

                    'copy from buffer into monitor structure
                    IECMonitor = CType(Marshal.PtrToStructure(BuffPtr, GetType(MonitorStruct)), MonitorStruct)
                    Handle.Free() 'free handle for when inputbuffer updated next

                    'parse data from monitorstruct into text boxes, reverse bytes
                    'Axis 1
                    If RadioButton2.Checked Then
                        bytes = BitConverter.GetBytes(IECMonitor.Axis1.Position)
                        Array.Reverse(bytes)
                        IECMonitor.Axis1.Position = BitConverter.ToDouble(bytes, 0)
                        bytes = BitConverter.GetBytes(IECMonitor.Axis1.Velocity)
                        Array.Reverse(bytes)
                        IECMonitor.Axis1.Velocity = BitConverter.ToDouble(bytes, 0)
                        bytes = BitConverter.GetBytes(IECMonitor.Axis1.Torque)
                        Array.Reverse(bytes)
                        IECMonitor.Axis1.Torque = BitConverter.ToDouble(bytes, 0)
                    End If

                    txtAxis1Pos.Text = Format$(IECMonitor.Axis1.Position, "00000.000")
                    txtAxis1Vel.Text = Format$(IECMonitor.Axis1.Velocity, "00000.000")
                    txtAxis1Trq.Text = Format$(IECMonitor.Axis1.Torque, "00000.000")
                    If IECMonitor.Axis1.Enabled > 0 Then
                        ledAxis1Status.FillColor = Color.LimeGreen
                    Else
                        ledAxis1Status.FillColor = Color.Red
                    End If

                    If IECMonitor.Axis1.Alarm > 0 Then
                        ledAxis1Alarm.FillColor = Color.Red
                        txtAxis1ErrorID.Text = IECMonitor.Axis1.ErrorID
                    Else
                        ledAxis1Alarm.FillColor = Color.White
                        txtAxis1ErrorID.Text = vbNullString
                    End If

                    'Axis 2
                    If RadioButton2.Checked Then
                        bytes = BitConverter.GetBytes(IECMonitor.Axis2.Position)
                        Array.Reverse(bytes)
                        IECMonitor.Axis2.Position = BitConverter.ToDouble(bytes, 0)
                        bytes = BitConverter.GetBytes(IECMonitor.Axis2.Velocity)
                        Array.Reverse(bytes)
                        IECMonitor.Axis2.Velocity = BitConverter.ToDouble(bytes, 0)
                        bytes = BitConverter.GetBytes(IECMonitor.Axis2.Torque)
                        Array.Reverse(bytes)
                        IECMonitor.Axis2.Torque = BitConverter.ToDouble(bytes, 0)
                    End If


                    txtAxis2Pos.Text = Format$(IECMonitor.Axis2.Position, "00000.000")
                    txtAxis2Vel.Text = Format$(IECMonitor.Axis2.Velocity, "00000.000")
                    txtAxis2Trq.Text = Format$(IECMonitor.Axis2.Torque, "00000.000")
                    If IECMonitor.Axis2.Enabled > 0 Then
                        ledAxis2Status.FillColor = Color.LimeGreen
                    Else
                        ledAxis2Status.FillColor = Color.Red
                    End If

                    If IECMonitor.Axis2.Alarm > 0 Then
                        ledAxis2Alarm.FillColor = Color.Red
                        txtAxis2ErrorID.Text = IECMonitor.Axis2.ErrorID
                    Else
                        ledAxis2Alarm.FillColor = Color.White
                        txtAxis2ErrorID.Text = vbNullString
                    End If

                    'Axis 3
                    If RadioButton2.Checked Then
                        bytes = BitConverter.GetBytes(IECMonitor.Axis3.Position)
                        Array.Reverse(bytes)
                        IECMonitor.Axis3.Position = BitConverter.ToDouble(bytes, 0)
                        bytes = BitConverter.GetBytes(IECMonitor.Axis3.Velocity)
                        Array.Reverse(bytes)
                        IECMonitor.Axis3.Velocity = BitConverter.ToDouble(bytes, 0)
                        bytes = BitConverter.GetBytes(IECMonitor.Axis3.Torque)
                        Array.Reverse(bytes)
                        IECMonitor.Axis3.Torque = BitConverter.ToDouble(bytes, 0)
                    End If


                    txtAxis3Pos.Text = Format$(IECMonitor.Axis3.Position, "00000.000")
                    txtAxis3Vel.Text = Format$(IECMonitor.Axis3.Velocity, "00000.000")
                    txtAxis3Trq.Text = Format$(IECMonitor.Axis3.Torque, "00000.000")
                    If IECMonitor.Axis3.Enabled > 0 Then
                        ledAxis3Status.FillColor = Color.LimeGreen
                    Else
                        ledAxis3Status.FillColor = Color.Red
                    End If

                    If IECMonitor.Axis3.Alarm > 0 Then
                        ledAxis3Alarm.FillColor = Color.Red
                        txtAxis3ErrorID.Text = IECMonitor.Axis3.ErrorID
                    Else
                        ledAxis3Alarm.FillColor = Color.White
                        txtAxis3ErrorID.Text = vbNullString
                    End If

                    'Axis 4
                    If RadioButton2.Checked Then
                        bytes = BitConverter.GetBytes(IECMonitor.Axis4.Position)
                        Array.Reverse(bytes)
                        IECMonitor.Axis4.Position = BitConverter.ToDouble(bytes, 0)
                        bytes = BitConverter.GetBytes(IECMonitor.Axis4.Velocity)
                        Array.Reverse(bytes)
                        IECMonitor.Axis4.Velocity = BitConverter.ToDouble(bytes, 0)
                        bytes = BitConverter.GetBytes(IECMonitor.Axis4.Torque)
                        Array.Reverse(bytes)
                        IECMonitor.Axis4.Torque = BitConverter.ToDouble(bytes, 0)
                    End If

                    txtAxis4Pos.Text = Format$(IECMonitor.Axis4.Position, "00000.000")
                    txtAxis4Vel.Text = Format$(IECMonitor.Axis4.Velocity, "00000.000")
                    txtAxis4Trq.Text = Format$(IECMonitor.Axis4.Torque, "00000.000")
                    If IECMonitor.Axis4.Enabled > 0 Then
                        ledAxis4Status.FillColor = Color.LimeGreen
                    Else
                        ledAxis4Status.FillColor = Color.Red
                    End If

                    If IECMonitor.Axis4.Alarm > 0 Then
                        ledAxis4Alarm.FillColor = Color.Red
                        txtAxis4ErrorID.Text = IECMonitor.Axis4.ErrorID
                    Else
                        ledAxis4Alarm.FillColor = Color.White
                        txtAxis4ErrorID.Text = vbNullString
                    End If
                    '  txtResponse.Text = System.Text.Encoding.UTF8.GetString(MPResponse) & vbCrLf  
                End If
            End If
        End If

    End Sub


    Private Sub txtFeedPos_TextChanged(sender As Object, e As EventArgs) Handles txtAxis1Pos.TextChanged

    End Sub



    Private Sub ledStatus_Click(sender As Object, e As EventArgs) Handles ledStatus.Click

    End Sub

    Private Sub cmdEnable_Click(sender As Object, e As EventArgs) Handles cmdEnable.Click

        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("EN,1" & vbCrLf))
        End If

    End Sub

    Private Sub cmdDisable_Click(sender As Object, e As EventArgs) Handles cmdDisable.Click

        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("EN,0" & vbCrLf))
        End If

    End Sub

    Private Sub cmdJogAxis1Pos_MouseDown(sender As Object, e As EventArgs) Handles cmdJogAxis1Pos.MouseDown
        'Axis1 jog positive start
        If tcpClient.Client.Connected Then
            If txtSetAxis1Speed.Text = vbNullString Then
                MsgBox("No speed value entered")
            Else
                tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("JG,1," & txtSetAxis1Speed.Text * 1 & vbCrLf))
            End If

        End If

    End Sub

    Private Sub cmdJogAxis1Pos_MouseUp(sender As Object, e As EventArgs) Handles cmdJogAxis1Pos.MouseUp
        'Axis1 jog positive stop
        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("ST,1,100.0" & vbCrLf))
        End If
    End Sub


    Private Sub cmdJogAxis1Neg_MouseDown(sender As Object, e As EventArgs) Handles cmdJogAxis1Neg.MouseDown
        ' Axis1 jog negative start
        If tcpClient.Client.Connected Then
            If txtSetAxis1Speed.Text = vbNullString Then
                MsgBox("No speed value entered")
            Else
                tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("JG,1," & txtSetAxis1Speed.Text * -1 & vbCrLf))
            End If

        End If

    End Sub

    Private Sub cmdJogAxis1Neg_MouseUp(sender As Object, e As EventArgs) Handles cmdJogAxis1Neg.MouseUp
        'Axis1 jog negative stop
        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("ST,1,100.0" & vbCrLf))
        End If
    End Sub

    Private Sub cmdJogAxis2Pos_MouseDown(sender As Object, e As EventArgs) Handles cmdJogAxis2Pos.MouseDown
        'Axis2 jog positive start
        If tcpClient.Client.Connected Then
            If txtSetAxis2Speed.Text = vbNullString Then
                MsgBox("No speed value entered")
            Else
                tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("JG,2," & txtSetAxis2Speed.Text & vbCrLf))
            End If

        End If

    End Sub

    Private Sub cmdJogAxis2Pos_MouseUp(sender As Object, e As EventArgs) Handles cmdJogAxis2Pos.MouseUp
        'Axis2 jog positive stop
        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("ST,2,100.0" & vbCrLf))
        End If
    End Sub


    Private Sub cmdJogAxis2Neg_MouseDown(sender As Object, e As EventArgs) Handles cmdJogAxis2Neg.MouseDown
        ' Axis2 jog negative start
        If tcpClient.Client.Connected Then
            If txtSetAxis2Speed.Text = vbNullString Then
                MsgBox("No speed value entered")
            Else
                tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("JG,2," & txtSetAxis2Speed.Text * -1 & vbCrLf))
            End If

        End If

    End Sub

    Private Sub cmdJogAxis2Neg_MouseUp(sender As Object, e As EventArgs) Handles cmdJogAxis2Neg.MouseUp
        'Axis2 jog negative stop
        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("ST,2,100.0" & vbCrLf))
        End If
    End Sub

    Private Sub cmdJogAxis3Pos_MouseDown(sender As Object, e As EventArgs) Handles cmdJogAxis3Pos.MouseDown
        'Axis3 jog positive start
        If tcpClient.Client.Connected Then
            If txtSetAxis3Speed.Text = vbNullString Then
                MsgBox("No speed value entered")
            Else
                tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("JG,3," & txtSetAxis3Speed.Text & vbCrLf))
            End If
        End If

    End Sub

    Private Sub cmdJogAxis3Pos_MouseUp(sender As Object, e As EventArgs) Handles cmdJogAxis3Pos.MouseUp
        'Axis3 jog positive stop
        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("ST,3,100.0" & vbCrLf))
        End If
    End Sub


    Private Sub cmdJogAxis3Neg_MouseDown(sender As Object, e As EventArgs) Handles cmdJogAxis3Neg.MouseDown
        ' Axis3 jog negative start
        If tcpClient.Client.Connected Then
            If txtSetAxis3Speed.Text = vbNullString Then
                MsgBox("No speed value entered")
            Else
                tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("JG,3," & txtSetAxis3Speed.Text * -1 & vbCrLf))
            End If
        End If

    End Sub

    Private Sub cmdJogAxis3Neg_MouseUp(sender As Object, e As EventArgs) Handles cmdJogAxis3Neg.MouseUp
        'Axis3 jog negative stop
        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("ST,3,100.0" & vbCrLf))
        End If
    End Sub

    Private Sub cmdJogAxis4Pos_MouseDown(sender As Object, e As EventArgs) Handles cmdJogAxis4Pos.MouseDown
        'Axis4 jog positive start
        If tcpClient.Client.Connected Then
            If txtSetAxis4Speed.Text = vbNullString Then
                MsgBox("No speed value entered")
            Else
                tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("JG,4," & txtSetAxis4Speed.Text & vbCrLf))
            End If
        End If

    End Sub

    Private Sub cmdJogAxis4Pos_MouseUp(sender As Object, e As EventArgs) Handles cmdJogAxis4Pos.MouseUp
        'Axis4 jog positive stop
        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("ST,4,100.0" & vbCrLf))
        End If
    End Sub


    Private Sub cmdJogAxis4Neg_MouseDown(sender As Object, e As EventArgs) Handles cmdJogAxis4Neg.MouseDown
        ' Axis4 jog negative start
        If tcpClient.Client.Connected Then
            If txtSetAxis4Speed.Text = vbNullString Then
                MsgBox("No speed value entered")
            Else
                tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("JG,4," & txtSetAxis4Speed.Text * -1 & vbCrLf))
            End If
        End If

    End Sub

    Private Sub cmdJogAxis4Neg_MouseUp(sender As Object, e As EventArgs) Handles cmdJogAxis4Neg.MouseUp
        'Axis4 jog negative stop
        If tcpClient.Client.Connected Then
            tcpClient.Client.Send(System.Text.Encoding.UTF8.GetBytes("ST,4,100.0" & vbCrLf))
        End If
    End Sub

End Class
